/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.BeatListener;
import control.EnemyControl;
import control.MinimObject;
import data.Constants;
import ddf.minim.AudioOutput;
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.analysis.BeatDetect;
import ddf.minim.analysis.FFT;
import java.io.IOException;
import java.util.Random;
import model.EnemyModel;
import org.lwjgl.opengl.GL11;

public class SoundControl {
    Minim minim;
    AudioPlayer song;
    AudioOutput out;
    FFT fft;
    private FFT fftLog;
    float[] fftPrev;
    float[] fftDiff;
    boolean[] beats;
    int[] groupings;
    BeatDetect beat;
    BeatListener bl;
    int bands = 256;
    int maxBass;
    int bass = 0;
    int frame;
    int fftType;
    float fftThreshold;
    float fftLeftThreshold;
    int enemiesGenned;
    int consecFramesGenned;
    private int songLength;
    private boolean songOver;
    private long songPause;
    private int songFade = 700;
    private boolean fadeEnter;
    private boolean ourPause;
    float largeAmp;
    int largeBand;
    Random rand = new Random(5L);

    public SoundControl(String s) throws IOException {
        MinimObject minimObj = new MinimObject();
        this.minim = new Minim(minimObj);
        this.maxBass = Constants.MAX_PLAYER_SIZE;
        this.frame = Constants.FRAME_TO_GENERATE_ENEMIES;
        this.fftThreshold = Constants.FFT_THRESHOLD;
        this.fftLeftThreshold = Constants.FFT_LEFT_THRESHOLD;
        this.consecFramesGenned = 0;
        this.song = this.minim.loadFile(s);
        this.songLength = this.song.length();
        this.songOver = false;
        this.fadeEnter = false;
        this.fft = new FFT(this.song.bufferSize(), this.song.sampleRate());
        this.fft.linAverages(this.bands);
        this.setFftLog(new FFT(this.song.bufferSize(), this.song.sampleRate()));
        this.getFftLog().logAverages(22, 12);
        this.fftPrev = new float[this.bands];
        this.fftDiff = new float[this.bands];
        this.groupings = new int[120];
        this.beats = new boolean[120];
        this.beat = new BeatDetect(this.song.bufferSize(), this.song.sampleRate());
        this.beat.setSensitivity(10);
        this.bl = new BeatListener(this.beat, this.song);
    }

    public int getBassBeat() {
        if (this.bass > 0) {
            --this.bass;
        }
        if (this.beat.isKick()) {
            this.bass = this.maxBass;
        }
        return this.bass;
    }

    public void visualizer() {
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glColor4d(1.0, 1.0, 1.0, 0.2);
        GL11.glPolygonMode(1028, 6914);
        int w = this.getFftLog().specSize() / this.bands;
        int q = Constants.VIEW_HEIGHT;
        int i = 0;
        while (i < this.getFftLog().avgSize()) {
            GL11.glBegin(9);
            GL11.glVertex2d(i * w, q);
            GL11.glVertex2d(i * w + w, q);
            GL11.glVertex2d(i * w + w, (float)q - this.getFftLog().getAvg(i) * 1.0f);
            GL11.glVertex2d(i * w, (float)q - this.getFftLog().getAvg(i) * 1.0f);
            GL11.glEnd();
            ++i;
        }
        GL11.glDisable(3042);
    }

    public void update(EnemyControl e) {
        GL11.glPopAttrib();
        this.fftLogUpdate();
        GL11.glPushAttrib(1048575);
        this.genEnemies(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 2, e);
    }

    public void genEnemies(float centerX, float centerY, EnemyControl eC) {
        int[] stuff = this.computeGroupings();
        float temp = 360 / this.getFftLog().avgSize();
        float theta = (float)stuff[1] * temp;
        if (Constants.bPseudoRandomTheta) {
            theta += this.rand.nextFloat() * 360.0f;
        }
        int baseRadius = Constants.MIN_SPAWN_RADIUS;
        float increment = (float)Math.PI * 2 / (float)stuff[0];
        float newX = 0.0f;
        float newY = 0.0f;
        float newRadius = 0.0f;
        this.enemiesGenned = 0;
        boolean inGroup = false;
        int i = 0;
        while (i < this.getFftLog().avgSize()) {
            if (inGroup && this.groupings[i] <= 0) {
                newRadius = (float)baseRadius + this.getFftLog().getAvg(i) * 1.0f;
                newX = (float)((double)newRadius * Math.cos(theta) + (double)centerX);
                newY = (float)((double)newRadius * Math.sin(theta) + (double)centerY);
                int j = 0;
                while (j < eC.enemies.size()) {
                    float xDiff = (float)Math.pow(newX - eC.enemies.get((int)j).x, 2.0);
                    float yDiff = (float)Math.pow(newY - eC.enemies.get((int)j).y, 2.0);
                    Math.sqrt(xDiff + yDiff);
                    ++j;
                }
                EnemyModel e = new EnemyModel(newX, newY, i, this.getFftLog().getAvg(i), this.groupings[i - 1]);
                eC.add(e);
                theta += increment;
                inGroup = false;
                ++this.enemiesGenned;
            }
            if (this.groupings[i] > 0) {
                inGroup = true;
            }
            ++i;
        }
    }

    public int[] computeGroupings() {
        int counter = 0;
        int numEnemies = 0;
        float max = 0.0f;
        int maxBand = 0;
        int i = 1;
        while (i < this.getFftLog().avgSize()) {
            if (this.getFftLog().getAvg(i) - this.getFftLog().getAvg(i - 1) >= this.fftLeftThreshold && this.beats[i]) {
                this.groupings[i] = counter++;
            } else if (this.getFftLog().getAvg(i) >= this.fftThreshold && counter != 1 && this.beats[i]) {
                this.groupings[i] = counter++;
            } else {
                this.groupings[i] = 0;
                counter = 1;
            }
            if (this.groupings[i] == 1) {
                ++numEnemies;
            }
            if (this.getFftLog().getAvg(i) >= max) {
                max = this.getFftLog().getAvg(i);
                maxBand = i;
            }
            ++i;
        }
        int[] stuff = new int[]{numEnemies, maxBand};
        return stuff;
    }

    public void fftLogUpdate() {
        this.fftThreshold = Constants.FFT_THRESHOLD;
        int i = 0;
        while (i < this.getFftLog().avgSize()) {
            this.fftPrev[i] = this.getFftLog().getAvg(i);
            ++i;
        }
        this.getFftLog().forward(this.song.mix);
        this.largeAmp = this.getFftLog().getAvg(0);
        this.largeBand = 0;
        i = 0;
        while (i < this.getFftLog().avgSize()) {
            this.fftDiff[i] = this.getFftLog().getAvg(i) - this.fftPrev[i];
            this.beats[i] = this.fftDiff[i] >= this.fftThreshold;
            if (this.fft.getAvg(i) > this.largeAmp) {
                this.largeAmp = this.getFftLog().getAvg(i);
                this.largeBand = i;
            }
            ++i;
        }
        if (this.enemiesGenned > 0) {
            ++this.consecFramesGenned;
        } else if (this.enemiesGenned == 0) {
            --this.consecFramesGenned;
            if (this.consecFramesGenned < 0) {
                this.consecFramesGenned = 0;
            }
        }
        if (this.consecFramesGenned == 0 && Constants.FFT_THRESHOLD > Constants.FFT_THRESHOLD_MIN) {
            Constants.FFT_THRESHOLD -= 1.0f;
        }
        if (this.consecFramesGenned >= 2 && Constants.FFT_THRESHOLD < Constants.FFT_THRESHOLD_MAX) {
            Constants.FFT_THRESHOLD += 1.0f;
        }
    }

    public void start() {
        this.song.play();
        this.ourPause = false;
    }

    public void stop() {
        this.song.close();
        this.minim.stop();
    }

    public boolean isEndOfSong() {
        if (this.songOver) {
            return true;
        }
        if (!this.song.isPlaying() && !this.ourPause) {
            this.songOver = true;
            return true;
        }
        return false;
    }

    public int getSongLength() {
        return this.songLength;
    }

    public void setGainShift(float gain) {
        this.song.shiftGain(this.song.getGain(), gain, this.songFade);
    }

    public void pauseSong() {
        if (!this.fadeEnter) {
            this.songPause = System.currentTimeMillis();
            this.setGainShift(-30.0f);
            this.fadeEnter = true;
        }
        if (this.song.isPlaying() && System.currentTimeMillis() - this.songPause >= (long)this.songFade) {
            this.song.pause();
        }
        this.ourPause = true;
    }

    public void resumeSong() {
        if (this.fadeEnter) {
            this.song.play();
            this.setGainShift(0.0f);
            this.fadeEnter = false;
        }
        this.ourPause = false;
    }

    public boolean isPlaying() {
        return this.song.isPlaying();
    }

    public FFT getFftLog() {
        return this.fftLog;
    }

    public void setBalance(float balance) {
        this.song.setBalance(balance);
    }

    public long getPosition() {
        if (this.songOver) {
            return this.songLength;
        }
        return this.song.position();
    }

    public void setFftLog(FFT fftLog) {
        this.fftLog = fftLog;
    }
}

